CONTRIBUTING
------------

You may setup your local environment with [DDEV]. This project leverages the
[DDEV Drupal Contrib] plugin.

1.  [Install DDEV] with a [Docker provider].
2.  Clone this project's repository from Drupal's GitLab.

        git clone git@git.drupal.org:project/ai_migration.git
        cd ai_migration

3.  Create a local `.env` file by copying the example `.env.copy-me` file in `.ddev`.

        cp .ddev/.env.copy-me .ddev/.env

4. Edit the values in `.ddev/.env`. Specifically, enter your AI Provider API Key. `.env` is gitignored.

        AI_PROVIDER_API_KEY=[your value here]

5.  Startup DDEV.

        ddev start

6.  Install composer dependencies.

        ddev poser

    Note: `ddev poser` is shorthand for `ddev composer` to add in Drupal core dependencies
    without needing to modify the root composer.json. Find out more in DDEV Drupal Contrib
    [commands].

7.  Install Drupal.

        ddev drush site:install

8.  Visit site in browser.

        ddev describe

    Or, login as user 1:

        ddev drush uli

9.  Enable test discovery by editing your settings.php file and adding this line:

        $settings['extension_discovery_scan_tests'] = TRUE;

10. Enable modules.

        ddev drush en -y ai,ai_test,ai_migration,ai_migration_example,migrate,migrate_plus,migrate_tools,gemini_provider,ai_api_explorer,ai_logging,media,media_library,jsonapi,schemata,schemata_json_schema,serialization

11. Add your AI API Provider key at https://ai-migration.ddev.site/admin/config/system/keys/add. 

    * Set Key type to Authentication
    * Set Key provider to Environment
    * Set Environment variable to AI_PROVIDER_API_KEY
    * Save

12. Go to https://ai-migration.ddev.site/admin/config/ai/providers, click on your Provider and configure as needed. You will need to specify the key that you set up in the previous step.

13.  Go to https://ai-migration.ddev.site/admin/config/ai/settings and confirm that your API provider is set as the default for **Chat** and **Chat with Structured Response**.

14. Push work to Merge Requests (MRs) opened via this project's [issue queue].


CHANGING DRUPAL CORE VERSION
----------------------------

DDEV Drupal Contrib installs a recent stable version of Drupal core via the `DRUPAL_CORE`
environment variable. Review .ddev/config.yaml to find the current default version.

Override the current default version of Drupal core by creating .ddev/config.local.yaml:

```yaml
web_environment:
    - DRUPAL_CORE=^10
```

UPDATING DEPENDENCIES
---------------------

This project depends on 3rd party PHP libraries. It also specifies suggested "dev dependencies"
for contribution on local development environments. Occasionally, DDEV and DDEV Drupal Contrib
must be updated as well.

1.  Create an issue, MR, and checkout the MR branch.
2.  Update DDEV and DDEV Drupal Contrib itself.

    Read https://ddev.readthedocs.io/en/stable/users/install/ddev-upgrade/

        ddev config --update
        ddev get ddev/ddev-drupal-contrib
        ddev restart
        ddev poser
        ddev symlink-project

3.  Review and update PHP dependencies defined in composer.json

        ddev composer outdated --direct

3.  Test clean install, commit, and push.


[DDEV]: https://www.ddev.com/
[DDEV Drupal Contrib]: https://github.com/ddev/ddev-drupal-contrib
[Install DDEV]: https://ddev.readthedocs.io/en/stable/
[Docker provider]: https://ddev.readthedocs.io/en/stable/users/install/docker-installation/
[issue queue]: https://www.drupal.org/project/issues/ai_migration
[commands]: https://github.com/ddev/ddev-drupal-contrib#commands
