<?php

namespace Drupal\ai_migration\Attribute;

use Drupal\Component\Plugin\Attribute\AttributeBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines an ai_prompt attribute.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
final class AiPrompt extends AttributeBase {

  /**
   * Constructs a new AiPrompt instance.
   *
   * @param string $id
   *   The plugin ID. There are some implementation bugs that make the plugin
   *   available only if the ID follows a specific pattern. The ai prompt
   *   pattern must be similar to ai_migration_prompt:string.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $label
   *   (optional) The human-readable name of the plugin.
   * @param int $weight
   *   (optional) The weight of the group. Default is 0.
   * @param string|null $type
   *   (optional) The type of prompt, e.g. 'string', 'file'.
   * @param bool|null $is_default
   *   (optional) Whether the prompt is the default prompt. Default is FALSE.
   */
  public function __construct(
    protected readonly string $id,
    protected readonly ?TranslatableMarkup $label = NULL,
    protected readonly int $weight = 0,
    protected readonly ?string $type = NULL,
    protected readonly ?bool $is_default = FALSE,
  ) {
    // Do not call parent::__construct() here.
  }

}
