<?php

declare(strict_types=1);

namespace Drupal\ai_migration\Enum;

use Drupal\ai_migration\Trait\EnumValidMethodsTrait;

/**
 * Prompt operations for AI migration.
 */
enum PromptOperation: string {

  use EnumValidMethodsTrait;

  case Prepend = 'prepend';
  case Append = 'append';
  case Replace = 'replace';

  /**
   * Modify the original string with the add string.
   *
   * @param string $original_string
   *   The original string.
   * @param string $add_string
   *   The string to modify the original string with.
   * @param bool $eol
   *   Whether to add a new line character for operation.
   *
   * @return string
   *   The modified string based operation value.
   */
  public function modify(string $original_string, string $add_string, bool $eol = TRUE): string {
    $eol_string = $eol ? PHP_EOL : '';

    return match ($this) {
      self::Prepend => $add_string . $eol_string . $original_string,
      self::Append => $original_string . $eol_string . $add_string,
      self::Replace => $add_string
    };
  }

}
