<?php

declare(strict_types=1);

namespace Drupal\ai_migration;

use Symfony\Component\HtmlSanitizer\HtmlSanitizerConfig;

/**
 * Interface for HTML sanitizer configuration builder.
 */
interface HtmlSanitizerConfigBuilderInterface {

  /**
   * Build a sanitizer config object from options.
   *
   * @param array $options
   *   The configuration options.
   *
   * @return \Symfony\Component\HtmlSanitizer\HtmlSanitizerConfig
   *   The configured HtmlSanitizerConfig object.
   *
   * @throws \InvalidArgumentException
   *   When an invalid option is provided.
   */
  public function build(array $options): HtmlSanitizerConfig;

}
