<?php

namespace Drupal\ai_migration\Plugin\ai_migration\prompt;

use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Defines an interface for AI migration prompt plugins.
 *
 * All prompt plugins must implement this interface.
 */
interface AiPromptInterface extends PluginInspectionInterface {

  /**
   * Processes the prompt configuration and returns a prompt.
   *
   * @param array $configuration
   *   The configuration for the prompt, e.g., ['text' => '...'].
   *
   * @return string
   *   The fully constructed AI prompt text.
   */
  public function getPrompt(array $configuration): string;

}
