<?php

namespace Drupal\ai_migration\Plugin\ai_migration\prompt;

use Drupal\ai_migration\Attribute\AiPrompt;
use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Get the prompt text from a string in the configuration.
 */
#[AiPrompt(
  id: 'ai_migration_prompt:string',
  label: new TranslatableMarkup('AI migration string prompt'),
  type: 'string',
  is_default: TRUE,
)]
class PromptString extends PluginBase implements AiPromptInterface {

  /**
   * {@inheritdoc}
   */
  public function getPrompt(array $configuration): string {
    return trim($configuration['prompt'] ?? '');
  }

}
