<?php

declare(strict_types=1);

namespace Drupal\ai_migration\Trait;

/**
 * Provides a trait for getting valid items from an enum.
 */
trait EnumValidMethodsTrait {

  /**
   * Gets all valid items for the Enum.
   *
   * @return array
   *   Array of valid values.
   */
  public static function getValidItems(): array {
    return array_column(self::cases(), 'value');
  }

  /**
   * Checks if a given string is a valid item in the Enum.
   *
   * @param string $key
   *   The key value to check.
   *
   * @return bool
   *   TRUE if is valid, FALSE otherwise.
   */
  public static function isValid(string $key): bool {
    return in_array($key, self::getValidItems());
  }

}
