<?php

declare(strict_types=1);

namespace Drupal\Tests\ai_migration\Kernel;

use Drupal\ai_migration\Plugin\ai_migration\prompt\PromptString;
use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\ai_migration\Trait\PromptRoleProviderTrait;
use PHPUnit\Framework\Attributes\CoversMethod;
use PHPUnit\Framework\Attributes\Group;

/**
 * @coversDefaultClass \Drupal\ai_migration\Plugin\ai_migration\prompt\PromptString
 */
#[Group("ai_migration")]
#[CoversMethod(PromptString::class, 'getPrompt')]
class PromptStringPluginTest extends KernelTestBase {

  use PromptRoleProviderTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'ai',
    'ai_migration',
    'file',
    'jsonapi',
    'schemata',
    'schemata_json_schema',
    'serialization',
  ];

  /**
   * The Prompt Plugin manager.
   *
   * @var \Drupal\ai_migration\Service\AiMigrationPromptManager
   */
  protected $promptManager;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->promptManager = $this->container->get('ai_migration.prompt_manager');
  }

  /**
   * Tests that the plugin is findable and can be instantiated.
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  public function testPluginInstantiation(): void {
    $this->assertInstanceOf(PromptString::class, $this->promptManager->getPluginByType('string'));
  }

  /**
   * Tests the getPrompt method with the prompt set in the config for all roles.
   *
   * @dataProvider promptRoleProvider
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  public function testSetConfigPrompt(string $role): void {
    $prompt = $this->randomString();

    $this->promptManager->setConfig([
      [
        'type' => 'string',
        'role' => $role,
        'prompt' => $prompt,
      ],
    ]);

    $this->assertEquals($prompt, $this->promptManager->getPrompt($role));
  }

  /**
   * Test that string plugin is returned as default if no type is specified.
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  public function testStringPluginIsDefault(): void {
    $this->assertInstanceOf(PromptString::class, $this->promptManager->getDefaultPlugin());
  }

}
