<?php

declare(strict_types=1);

namespace Drupal\Tests\ai_migration\Trait;

use Drupal\ai_migration\Enum\PromptRole;

/**
 * Provides a test trait for prompt roles.
 */
trait PromptRoleProviderTrait {

  /**
   * Data provider for prompt roles.
   *
   * @return array[]
   *   The test cases.
   */
  public static function promptRoleProvider(): array {
    return [
      'user role' => [PromptRole::from('user')->value],
      'system role' => [PromptRole::from('system')->value],
    ];
  }

}
