
## Features

This module leverages Semantic Proximity measures to find the nodes that have
content semantically close to the currently displayed node.  It is equivalent
to Solr More Like This (MLT) functionality, but uses AI RAG Vector DB to find
the nodes that have the vectors with minimal distance from the current node.

The module provides a Views Contextual Filter that sends a single query to the
Vector DB to get a list of nodes semantically closest to the currently displayed content.
No LLMs are used to do a vector search to find the More Like This nodes,
therefore reducing the cost to zero.

## Post-Installation

1. Add Node Id field to the AI Index (Property path nid) to your Index if it doesn't have such a field.
2. Add Context Filter "AI More Like This" to a Views Block of your choice that will show a list of
semantically related nodes. The following configuration parameters must be specified:
<ul>
  <li> AI Search Index that populates Vector DB</li>
  <li> Similarity Metric used for similarity calculations. By default, the metric used in the AI Index is selected,
but it can be changed for better MLT results.</li>
  <li> Maximum 'distance' between the current node's vector and the vectors of MLT nodes. Range 0 - 1, defaults to 0.35 </li>
</ul>
3. Configure Maximum Number of results to be returned using the Block Pager "Display a specified number of items" configuration.
Note: the nodes with distance bigger than "Distance Threshold" will be filtered out.
4. Add the Block to a region of your choice.
