<?php

declare(strict_types=1);

namespace Drupal\ai_provider_acquia;

use Drupal\key\KeyValue;
use Drupal\key\Resolver\KeyResolverBase;
use Drupal\key\Resolver\KeyResolverInterface;

/**
 * Create a mock resolver that returns an alternate value for specific key ID.
 */
final class AcquiaAIEnvKeyResolver extends KeyResolverBase implements KeyResolverInterface {

  /**
   * The Acquia API Gateway Key name.
   */
  private const string ENV_NAME = 'AI_GATEWAY_API_KEY';

  /**
   * The Key ID to use for this resolver.
   */
  private const string KEY_ID = 'ai_gateway_key';

  /**
   * Set the API Keys from the Acquia AI Gateway.
   */
  protected function populateKeys(): void {
    if (getenv(self::ENV_NAME)) {
      $this->keys[self::KEY_ID] = new KeyValue(self::KEY_ID, $this->t('Acquia Gateway Key'), 'ai_provider_acquia', getenv(self::ENV_NAME));
    }
  }

}
