# Acquia AI Provider Module

Provides integration between your Drupal site and Acquia's hosted AI Gateway
service, Acquia AI [1]. requires the AI and Key modules.

[1] https://www.acquia.com/solutions/ai

## Features

- Connects Drupal's AI module with Acquia's AI Gateway service.
- Automatically provides you with access to multiple LLMs based on your subscription.
- Provides an admin interface for configuring API credentials and settings.
- Allows users to enable operations like text generation, translation, and other AI-driven functionalities.
- Integrates automatically with the Key module to Acquia's platform, or manually override on your own hosting platform.

## Requirements

Refer to composer.json for specific version requirements. Generally, Acquia modules support the latest 3 major versions of Drupal (2 when first released).

- AI: The core AI module must be installed and enabled.
- Key: For managing API keys securely.
- Acquia AI Gateway account: Talk to an Acquia Account Manager to get access to the gateway. Once enabled, the module should work automatically.

## Installation

1. Download with Composer and enable the module:

   ```
   composer require drupal/ai_provider_acquia:^1.0
   drush en ai_provider_acquia
   ```

2. Configure the Provider:

  - Navigate to `/admin/config/ai/settings`.
  - Select "Acquia AI Gateway" as your AI provider.

3. Ensure the following environment variables are set
  - `AI_GATEWAY_URL` This is the URL that connects to the Acquia AI service 
  - `AI_GATEWAY_API_KEY` This is the API Key use to authenticate into the service.
  - These URLs should be setup automatically by Acquia. If they are missing, contact your account manager to get them added to your application.

## Use Cases
- Intelligent Content Tagging: Automate taxonomy term suggestions and bulk content tagging to save time for large-scale migrations or updates.
- Content Summarization: Enable content previews or concise summaries of long reports to enhance user engagement and drive actionable insights.
- Personalization: Use AI to group related articles and provide personalized suggestions based on user behavior for smarter navigation and higher engagement.
- Multilingual Support: Improve global reach by efficiently integrating AI-powered translation for multilingual content delivery.
- Operational Efficiency: Simplify routine tasks like SEO optimization, meta tag updates, and team collaboration, enabling faster time-to-market for campaigns.
- Scalable Content Management: Support AI-driven workflows across multiple sites and environments for centralized, efficient site management.
