<?php

namespace Drupal\ai_provider_alibabacloud;

use Drupal\ai\OperationType\Chat\StreamedChatMessage;
use Drupal\ai\OperationType\Chat\StreamedChatMessageIterator;

/**
 * Iterator for processing streamed chat messages from Alibaba Cloud.
 */
class AlibabaCloudChatMessageIterator extends StreamedChatMessageIterator {

  /**
   * {@inheritdoc}
   */
  public function getIterator(): \Generator {
    foreach ($this->iterator->getIterator() as $data) {
      // Parse the SSE data format from Alibaba Cloud.
      if (strpos($data, 'data:') === 0) {
        $json_str = substr($data, 5);
        $json_str = trim($json_str);

        if ($json_str === '[DONE]') {
          return;
        }

        $decoded = json_decode($json_str, TRUE);
        if ($decoded && isset($decoded['output'])) {
          $content = $decoded['output']['text'] ?? '';
          $role = 'assistant';
          $usage = $decoded['usage'] ?? [];

          yield new StreamedChatMessage($role, $content, $usage);
        }
      }
    }
  }

}
