<?php

namespace Drupal\ai_provider_anythingllm\OperationType\AiSearchApi;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\ai\Attribute\OperationType;
use Drupal\ai\OperationType\OperationTypeInterface;

/**
 * Interface for ai_search_api models.
 */
#[OperationType(
  id: 'ai_search_api',
  label: new TranslatableMarkup('AI Search API'),
)]
interface AiSearchApiInterface extends OperationTypeInterface {

  /**
   * Store a document to index.
   *
   * @param string $content
   *   Raw content of the document.
   * @param array $meta
   *   Metadata of the document.
   * @param string $index_name
   *   The machine name of search API index.
   * @param string $model_id
   *   The model_id (aka workspace) for AnythingLLM.
   *
   * @return string
   *   Filename of stored data document.
   */
  public function storeDocument($content, $meta, $index_name, $model_id): string;

  /**
   * Delete documents.
   *
   * @param array $item_ids
   *   Array of search API item IDs.
   * @param string $index_name
   *   The machine name of search API index.
   * @param string $model_id
   *   The model_id (aka workspace) for AnythingLLM.
   */
  public function deleteDocuments($item_ids, $index_name, $model_id): void;

  /**
   * Delete all documents from index.
   *
   * @param string $index_name
   *   The machine name of search API index.
   * @param string $model_id
   *   The model_id (aka workspace) for AnythingLLM.
   */
  public function deleteIndex($index_name, $model_id): void;

  /**
   * Search documents by search words.
   *
   * @param string $collection_name
   *   The name of the collection.
   * @param string $search_words
   *   The search terms.
   * @param array $output_fields
   *   The output fields.
   * @param mixed $filters
   *   The filters as prepared by the VDB provider in ::prepareFilters().
   * @param int $limit
   *   The limit.
   * @param int $offset
   *   The offset.
   *
   * @return array
   *   The results.
   */
  public function searchDocuments(
    string $collection_name,
    string $search_words,
    array $output_fields,
    mixed $filters = 'id not in [0]',
    int $limit = 10,
    int $offset = 0,
  ): array;

}
