<?php

declare(strict_types=1);

namespace Drupal\ai_provider_aws_bedrock\Attribute;

use Drupal\Component\Plugin\Attribute\AttributeBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * The bedrock model attribute.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
final class BedrockModel extends AttributeBase {

  /**
   * Constructs a new BedrockModel.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly ?string $deriver = NULL,
  ) {}

}
