<?php

namespace Drupal\ai_provider_aws_bedrock\Decorator;

use Aws\Result;

/**
 * This wraps the bedrock response to work with a json response.
 */
class BedrockJsonSerializeDecorator implements \JsonSerializable {

  /**
   * The original response.
   *
   * @var \Aws\Result
   */
  protected Result $response;

  /**
   * The construct method.
   *
   * @param \Aws\Result $response
   *   The original response.
   */
  public function __construct(Result $response) {
    $this->response = $response;
  }

  /**
   * {@inheritdoc}
   */
  public function jsonSerialize(): mixed {
    $json = [];
    foreach ($this->response as $key => $value) {
      if (is_array($value)) {
        $json[$key] = $value;
      }
      else {
        $json[$key] = (string) $value;
      }
    }
    return $json;
  }

}
