<?php

namespace Drupal\ai_provider_aws_bedrock\Models\Chat;

use Drupal\ai_provider_aws_bedrock\Attribute\BedrockModel;
use Drupal\ai\Enum\AiModelCapability;
use Drupal\ai_provider_aws_bedrock\Models\BedrockModelInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * The Meta Chat model.
 */
#[BedrockModel(
  id: 'meta.llama',
  label: new TranslatableMarkup('Meta Chat'),
)]
class MetaChat implements BedrockModelInterface {

  /**
   * {@inheritdoc}
   */
  public static function providerConfig(&$config, $model_id): void {

    $config['max_gen_len'] = $config['max_tokens'];
    unset($config['max_tokens']);
    $config['max_gen_len']['constraints']['max'] = 2048;
    $config['max_gen_len']['default'] = 512;

    $config['temperature']['default'] = 0.5;

    $config['top_p'] = [
      'type' => 'float',
      'label' => t('Top P'),
      'description' => t('The probability of sampling from the model.'),
      'default' => 0.9,
      'constraints' => [
        'min' => 0.1,
        'max' => 1.0,
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public static function providerCapabilities($capabilities, $model_id): bool {
    if (in_array(AiModelCapability::ChatWithImageVision, $capabilities)) {
      return strpos($model_id, 'vision') !== FALSE;
    }
    if (in_array(AiModelCapability::ChatJsonOutput, $capabilities)) {
      // If its 405b, then TRUE, otherwise FALSE.
      return strpos($model_id, '405b');
    }
    return TRUE;
  }

}
