<?php

namespace Drupal\ai_provider_aws_bedrock\Plugin\BedrockModel;

use Drupal\ai_provider_aws_bedrock\Attribute\BedrockModel;
use Drupal\ai\Enum\AiModelCapability;
use Drupal\ai_provider_aws_bedrock\Models\BedrockModelInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * The Ai21 Chat model.
 */
#[BedrockModel(
  id: 'ai21',
  label: new TranslatableMarkup('Ai21 Chat'),
)]
class Ai21Chat implements BedrockModelInterface {

  /**
   * {@inheritdoc}
   */
  public static function providerConfig(&$config, $model_id): void {

    $config['maxTokens'] = $config['max_tokens'];
    unset($config['max_tokens']);
    $config['maxTokens']['constraints']['max'] = 8191;
    $config['maxTokens']['default'] = 200;

    $config['topP'] = [
      'type' => 'float',
      'label' => t('Top P'),
      'default' => 0.5,
      'constraints' => [
        'min' => 0.1,
        'max' => 1.0,
        'step' => 0.001,
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public static function providerCapabilities($capabilities, $model_id): bool {
    if (in_array(AiModelCapability::ChatWithImageVision, $capabilities)) {
      return FALSE;
    }
    if (in_array(AiModelCapability::ChatJsonOutput, $capabilities)) {
      // If its grande, then TRUE, otherwise FALSE.
      return strpos($model_id, 'grande');
    }
    return TRUE;
  }

}
