<?php

namespace Drupal\ai_provider_aws_bedrock\Models\Chat;

use Drupal\ai_provider_aws_bedrock\Attribute\BedrockModel;
use Drupal\ai\Enum\AiModelCapability;
use Drupal\ai_provider_aws_bedrock\Models\BedrockModelInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * The Mistral Chat model.
 */
#[BedrockModel(
  id: 'mistral.mistral',
  label: new TranslatableMarkup('Mistral Chat'),
)]
class MistralChat implements BedrockModelInterface {

  /**
   * {@inheritdoc}
   */
  public static function providerConfig(&$config, $model_id): void {

    $config['max_tokens']['constraints']['max'] = 8192;
    $config['max_tokens']['default'] = 4096;

    $config['temperature']['default'] = 0.7;

    $config['top_p'] = [
      'type' => 'float',
      'label' => t('Top P'),
      'description' => t('The probability of sampling from the model.'),
      'default' => 1,
      'constraints' => [
        'min' => 0.1,
        'max' => 1.0,
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public static function providerCapabilities($capabilities, $model_id): bool {
    if (in_array(AiModelCapability::ChatWithImageVision, $capabilities)) {
      return FALSE;
    }
    if (in_array(AiModelCapability::ChatJsonOutput, $capabilities)) {
      // If its large, then TRUE, otherwise FALSE.
      return strpos($model_id, 'large');
    }
    return TRUE;
  }

}
