<?php

namespace Drupal\ai_provider_browser;

use Drupal\ai\OperationType\Chat\ChatInput;
use Drupal\ai\OperationType\Chat\ChatOutput;

/**
 * Interface for chat message requests in the Browser AI provider.
 */
interface ChatMessageRequestInterface {

  /**
   * The possibile statuses.
   */
  public const STATUS_RECEIVED = 'received';
  public const STATUS_PROCESSING = 'processing';
  public const STATUS_COMPLETED = 'completed';
  public const STATUS_FAILED = 'failed';
  public const STATUS_TIME_OUT = 'time_out';

  /**
   * Get the Request UUID.
   *
   * Every request will have a unique id.
   *
   * @return string
   *   The request uuid.
   */
  public function getRequestUuid(): string;

  /**
   * Sets the Request UUID.
   *
   * @param string $request_uuid
   *   The request uuid.
   *
   * @return static
   *   Returns the current instance.
   */
  public function setRequestUuid(string $request_uuid): static;

  /**
   * Get the ChatInput.
   *
   * @return \Drupal\ai\OperationType\Chat\ChatInput
   *   The chat input messages.
   */
  public function getChatInput(): ChatInput;

  /**
   * Set the ChatInput.
   *
   * @param \Drupal\ai\OperationType\Chat\ChatInput $input
   *   The chat input messages.
   *
   * @return static
   *   Returns the current instance.
   */
  public function setChatInput(ChatInput $input): static;

  /**
   * Get the ChatOutput.
   *
   * @return \Drupal\ai\OperationType\Chat\ChatOutput
   *   The chat output.
   */
  public function getChatOutput(): ChatOutput;

  /**
   * Set the ChatOutput.
   *
   * @param \Drupal\ai\OperationType\Chat\ChatOutput $output
   *   The chat output message.
   *
   * @return $this
   *   Returns the current instance.
   */
  public function setChatOutput(ChatOutput $output): static;

  /**
   * Gets the status.
   *
   * @return string
   *   The current status.
   */
  public function getStatus(): string;

  /**
   * Sets the status.
   *
   * @param string $status
   *   The status.
   *
   * @return static
   *   Returns the current instance.
   */
  public function setStatus(string $status): static;

  /**
   * Gets the error message.
   *
   * @return string
   *   Returns the current message.
   */
  public function getErrorMessage(): string;

  /**
   * Set error message.
   *
   * @param string $message
   *   The error message, why something failed.
   *
   * @return static
   *   Returns the current instance.
   */
  public function setErrorMessage(string $message): static;

  /**
   * Get created time.
   *
   * @return int
   *   The unix timestamp the request was created.
   */
  public function getCreatedTime(): int;

  /**
   * Set created time.
   *
   * @param int $created
   *   The unix timestamp the request was created.
   *
   * @return static
   *   Returns the current instance.
   */
  public function setCreatedTime(int $created): static;

  /**
   * Get running start time.
   *
   * @return int
   *   The unix timestamp the request started running.
   */
  public function getRunningStartTime(): int;

  /**
   * Set running start time.
   *
   * @param int $started
   *   The unix timestamp the request started running.
   *
   * @return static
   *   Returns the current instance.
   */
  public function setRunningStartTime(int $started): static;

  /**
   * Get updated time.
   *
   * @return int
   *   The unix timestamp the request was last updated.
   */
  public function getUpdatedTime(): int;

  /**
   * Set updated time.
   *
   * @param int $updated
   *   The unix timestamp the request was last updated.
   *
   * @return static
   *   Returns the current instance.
   */
  public function setUpdatedTime(int $updated): static;

  /**
   * Get the running time.
   *
   * @return int
   *   The seconds that has passed since it started running.
   */
  public function getRunningTime(): int;

  /**
   * Turn the whole object into an array.
   *
   * @return array
   *   The whole Chat message request.
   */
  public function toArray(): array;

  /**
   * Create from an array.
   *
   * @param array $request
   *   The current state of the request.
   *
   * @return static
   */
  public static function fromArray(array $request): static;

}
