<?php

namespace Drupal\ai_provider_browser\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure browser provider form.
 */
class BrowserConfigForm extends ConfigFormBase {

  /**
   * Config settings.
   */
  const CONFIG_NAME = 'ai_provider_browser.settings';

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ai_provider_browser_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      static::CONFIG_NAME,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config(static::CONFIG_NAME);

    $form['timeout'] = [
      '#type' => 'number',
      '#title' => $this->t('Timeout (seconds)'),
      '#default_value' => $config->get('timeout'),
      '#min' => 1,
      '#description' => $this->t('Maximum time to wait for a response from the AI provider.'),
      '#required' => TRUE,
    ];

    $form['polling_interval'] = [
      '#type' => 'number',
      '#title' => $this->t('Polling Interval (seconds)'),
      '#default_value' => $config->get('polling_interval'),
      '#min' => 1,
      '#description' => $this->t('Interval between polling attempts when checking for a response.'),
      '#required' => TRUE,
    ];

    $form['routes'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Allowed Routes'),
      '#default_value' => implode("\n", $config->get('routes') ?? []),
      '#description' => $this->t('List of allowed routes (one per line) where the browser provider can be used. Use "*" as a wildcard. Empty means all routes are allowed.'),
      '#required' => FALSE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Process routes input into an array.
    $routes_input = $form_state->getValue('routes');
    $routes = array_filter(array_map('trim', explode("\n", $routes_input)));
    // Retrieve the configuration.
    $this->config(static::CONFIG_NAME)
      ->set('timeout', $form_state->getValue('timeout'))
      ->set('polling_interval', $form_state->getValue('polling_interval'))
      ->set('routes', $routes)
      ->save();

    parent::submitForm($form, $form_state);
  }

}
