# AI Provider ByteDance

Drupal module that exposes ByteDance ModelArk as a provider for the [`drupal/ai`](https://www.drupal.org/project/ai) ecosystem. It lets site builders use ByteDance's chat and image generation models inside AI-powered Field UIs, Actions, or custom integrations without writing boilerplate client code.

## Features
- Registers a `bytedance` AI provider plugin that reuses the AI module's OpenAI-style transport layer.
- Supports chat, text-to-image, and image-to-image operations, including advanced parameters such as thinking mode, reasoning effort, sequential generation, watermarking, and prompt optimization.
- Includes a configuration form (`/admin/config/ai/providers/bytedance`) that relies on the Key module to securely store API keys.
- Ships defaults and schema definitions so deployments can be exported through Drupal config management.

## Requirements
- Drupal 10.3+ or 11
- [`drupal/ai` ^1.2](https://www.drupal.org/project/ai)
- [`drupal/key` ^1.18](https://www.drupal.org/project/key) to store the ByteDance API key
- An active ByteDance ModelArk account and API key

## Installation
1. Add the module via Composer:
   ```bash
   composer require drupal/ai_provider_bytedance
   ```
2. Enable the module (extension machine name `ai_provider_bytedance`) through the Drupal UI or Drush:
   ```bash
   drush en ai_provider_bytedance
   ```

## Configuration
1. Create a Key entity that stores your ByteDance API key (`Configuration » System » Keys`).
2. Visit `Configuration » AI » Providers » ByteDance Authentication` (`/admin/config/ai/providers/bytedance`).
3. Choose the Key entry, optionally override the default endpoint (`https://ark.ap-southeast.bytepluses.com/api/v3`), and save. The form validates the key/host by fetching the available models.
4. The module automatically seeds sensible default models (`skylark-pro-250415` for chat and `seedream-4-0-250828` for both image operations). You can override them per AI operation type if needed.

## Usage
- After configuration, select the ByteDance provider wherever the AI module exposes provider/model dropdowns (Fields, Actions, Views, etc.).
- Model settings inherit from the AI module defaults and expose ByteDance-specific options (thinking mode, reasoning effort, image size presets, sequential generation, seeds, watermarking, prompt optimization).
- Chat operations support text and multimodal (image) inputs; image endpoints accept URL or base64 payloads handled automatically by the provider.
- Configuration defaults live in `definitions/api_defaults.yml`, making it easy to inspect available parameters or adjust them when extending the module.

## Troubleshooting
- **Validation errors when saving the form** – ensure the Key entity actually contains the API key and the configured endpoint is reachable.
- **Rate limit / quota messages** – the provider maps ModelArk errors to Drupal AI exceptions (`AiRateLimitException`, `AiQuotaException`, etc.), so try reducing throughput or confirming account quotas.
- **Unsafe prompt** – ByteDance may reject certain prompts; these bubble up as `AiUnsafePromptException` messages in the UI/logs.

## Versioning & Releases
- `main` tracks the latest development work. Create compatibility branches such as `1.x` or `2.x` when you need to support multiple Drupal majors simultaneously.
- Publish stable builds by tagging commits with [Semantic Versioning](https://semver.org/) numbers (`1.0.0`, `1.0.1`, etc.). Composer consumers will automatically receive the matching release.
- Each tag must have a corresponding entry in `CHANGELOG.md`. Copy that entry into the GitLab Release notes so downstream sites can see what changed without diffing commits.
- Pre-release testing can happen on short-lived branches (for example `1.1.0-beta1`) before cutting the final tag.

## Contributing
Patches and feature requests are welcome. See the inline code comments and configuration schema (`config/schema/ai_provider_bytedance.schema.yml`) for guidance on extending settings or adding operations.
