# AI Provider: Dropsolid AI

## Overview

This module enables Drupal websites to use Dropsolid AI services through integration with other contributed modules. It provides users with a comprehensive setup wizard that guides them through configuring a complete AI stack, with plans for one-click SSO connection (coming soon) or manual configuration guidance for the optimal Dropsolid AI experience.

The module acts as a central configuration hub that helps users install, configure, and test all necessary AI components including LiteLLM providers, vector databases, tracing systems, and Dropsolid-specific AI extras.

## Requirements

- Drupal AI module (`ai`)
- AI Provider: LiteLLM (`ai_provider_litellm`)

## Installation

1. Enable the module via `ddev drush en ai_provider_dropsolidai` or through the Drupal UI.
2. Navigate to the configuration page to begin setup.

## Development

### Quality Assurance Tools

The module includes comprehensive development configuration files:

- **`phpcs.xml`** - Drupal coding standards enforcement
- **`phpstan.neon`** - Static analysis for type safety and code quality
- **`phpunit.xml`** - Unit, kernel, functional, and JavaScript testing configuration
- **`.cspell-project-words.txt`** - Spell checking with ai_provider_dropsolidai-specific vocabulary

### Running Quality Checks

```bash
# Code standards check
ddev exec ./vendor/bin/phpcs --standard=./web/modules/custom/ai_provider_dropsolidai/phpcs.xml ./web/modules/custom/ai_provider_dropsolidai/

# Static analysis
ddev exec ./vendor/bin/phpstan analyse -c ./web/modules/custom/ai_provider_dropsolidai/phpstan.neon ./web/modules/custom/ai_provider_dropsolidai/

# Unit tests
ddev exec ./vendor/bin/phpunit -c ./web/modules/custom/ai_provider_dropsolidai/phpunit.xml

# Spell check (if cspell is available in container)
ddev exec npx cspell "**/*.php" "**/*.md" --words-only --unique --config ./web/modules/custom/ai_provider_dropsolidai/.cspell-project-words.txt

# Alternative: Run spell check from host
npx cspell "./web/modules/custom/ai_provider_dropsolidai/**/*.php" "./web/modules/custom/ai_provider_dropsolidai/**/*.md" --words-only --unique --config ./web/modules/custom/ai_provider_dropsolidai/.cspell-project-words.txt
```

### Development Setup

1. Install the module dependencies with `composer install` within the Drupal project.
2. Execute automated checks via the commands above to verify upcoming changes.
3. Extend the scaffolding under `tests/` as provider features are implemented.

### Code Standards

This module follows strict Drupal coding standards and best practices:

- **SOLID Principles**: All classes follow single responsibility, dependency injection patterns
- **Proper Type Hinting**: Full type declarations throughout codebase
- **Community Standards**: PHPDoc comments, proper punctuation, and formatting
- **No Static Service Calls**: All services properly injected via dependency injection
- **AJAX Best Practices**: Container wrapper approach for real-time UI updates

## Configuration

Navigate to **Configuration → AI → Dropsolid.ai** (`/admin/config/ai/providers/dropsolidai`) to access the setup wizard.

## Manual Setup (Today)

The module currently provides a guided manual setup process through a vertical tab interface that walks users through installing and configuring:

1. **LiteLLM AI Provider** - Core AI provider for accessing multiple LLM services
2. **Vector Store (PostgreSQL)** - Optional vector database for AI embeddings and similarity search
3. **Tracing & Analytics (LangFuse)** - Optional AI interaction monitoring and analytics
4. **AI Extras (AI Dropsolid)** - Additional Dropsolid-specific AI features

**Key Features:**

- **Real-time Connection Testing**: AJAX-powered test buttons that validate each component's configuration and connectivity
- **Installation Guidance**: Direct links to Drupal.org projects with composer/drush installation instructions
- **Progress Tracking**: Visual checkboxes showing setup completion status for each component

## Coming Soon: SSO Auto-Setup

Future releases will include a one-click automatic setup feature that leverages Dropsolid platform SSO integration. This will allow users to:

- Authenticate with their Dropsolid platform account
- Automatically configure all AI services with proper credentials
- Skip manual configuration steps entirely
- Maintain centralized management through the Dropsolid control plane

The manual setup will remain available for users who prefer granular control or are not using the Dropsolid platform.

## Maintainers

- [Dropsolid AI Team](https://dropsolid.ai)
