<?php

declare(strict_types=1);

namespace Drupal\ai_provider_dropsolidai\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Placeholder controller for handling Dropsolid.ai SSO callbacks.
 */
final class SsoCallbackController extends ControllerBase {

  /**
   * Returns a placeholder response for SSO callbacks.
   */
  public function handle(Request $request): Response {
    $this->messenger()->addWarning($this->t('Dropsolid.ai single sign-on is not available yet.'));
    return $this->redirect('ai_provider_dropsolidai.settings_form');
  }

}
