# Google vertex provider

Google Vertex provider is an AI provider for the [AI module](https://www.drupal.org/project/ai) that lets you use chat models from the Vertex AI Model Garden (for example Gemini). Gemini also supports richer inputs such as documents and video.

## Features

- Use Gemini models from Vertex AI in your own Google Cloud project.
- High token limits compared to many other providers.
- Supports image, document, and video inputs (model dependent).

## Post-installation

### Google Cloud setup guide

#### Project setup
- Go to https://console.cloud.google.com and sign in.
- Create a new project or select an existing one.
- Link a Billing account to the project (required for many Vertex AI capabilities).
- Enable the **Vertex AI API** (`aiplatform.googleapis.com`) for the project.

#### Create a dedicated service account
- Go to **APIs & Services** → **Credentials**.
- Click **Create credentials** → **Service account**.
- Enter a name (for example: `drupal-vertex-ai`) and an optional description.
- Click **Create and continue**.

#### Grant IAM permissions (secure baseline)
- Add the role **Vertex AI User** (`roles/aiplatform.user`) to the service account. Predefined roles can be broader than needed, but this role is a good baseline to get the integration working.
- Click **Continue**.
- Leave **Principals with access** empty (unless your team needs additional admins for this service account).
- Click **Done**.

#### Optional: tighten to least privilege later
- Vertex AI recommends using **custom roles** if you want least-privilege access, because predefined roles often include more permissions than a workload requires.
- Once you know exactly which Vertex AI features you use (chat only, embeddings, image generation, and so on), replace `roles/aiplatform.user` with a custom role that includes only the required permissions.

#### Create and download credentials (JSON key)
- Open the service account you just created (`[account-name]@[project].iam.gserviceaccount.com`).
- Open the **Keys** tab.
- Click **Add key** → **Create new key**.
- Select **JSON**, then click **Create**.
- Store the downloaded JSON file securely. If someone obtains the private key, they can authenticate as the service account, which is similar to obtaining a password.
- Rotate keys periodically and delete unused keys to reduce the risk from credential leakage.

### Module installation

- Install: `composer require drupal/ai_provider_google_vertex`
- Enable: `drush en ai_provider_google_vertex`

### Module configuration

1. Create a new Key entity for storing Vertex AI credentials: **Configuration** → **System** → **Keys** (`/admin/config/system/keys`).
    - Choose a secure key provider by following [Drupal key management best practices](https://www.drupal.org/node/3264405).
    - If you use the **File** provider, set the file path to the downloaded service account JSON.
    - For other providers (for example environment variables), use the JSON content. Some providers require the JSON to be minified first (for example with `jq -c`).
2. Go to **Configuration** → **AI** → **Provider settings** → **Google vertex provider** (`/admin/config/ai/providers/google_vertex`).
3. Set **General Google Credentials** to the Key you created.
4. Click **Add** and choose the type of model to create.
5. Enter:
    - **Project ID** (Google Cloud project id from the JSON file).
    - **Location** (for example `europe-west4`).
    - **Model ID** (for example a Gemini model id from [Model Garden](https://docs.cloud.google.com/vertex-ai/generative-ai/docs/models)).
6. Click **Create model**.

## Getting streaming working

- Install and enable gRPC for PHP by following: https://cloud.google.com/php/grpc
- Your web server must support streaming responses (chunked output). (For DDEV, see the AI module docs: https://project.pages.drupalcode.org/ai/latest/developers/ddev/)

## Similar modules

If you want to call Gemini using Google AI Studio instead of Vertex AI, check out the [Gemini Provider](https://www.drupal.org/project/gemini_provider).
