<?php

namespace Drupal\ai_provider_moonshot\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\key\KeyRepositoryInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Configure Moonshot AI settings for this site.
 */
class SettingsForm extends ConfigFormBase
{

  /**
   * The key repository.
   *
   * @var \Drupal\key\KeyRepositoryInterface
   */
  protected $keyRepository;

  /**
   * Constructs a new SettingsForm object.
   *
   * @param \Drupal\key\KeyRepositoryInterface $key_repository
   *   The key repository.
   */
  public function __construct(KeyRepositoryInterface $key_repository)
  {
    $this->keyRepository = $key_repository;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container)
  {
    return new static(
      $container->get('key.repository')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId()
  {
    return 'ai_provider_moonshot_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames()
  {
    return ['ai_provider_moonshot.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state)
  {
    $config = $this->config('ai_provider_moonshot.settings');

    $form['api_key'] = [
      '#type' => 'key_select',
      '#title' => $this->t('API Key'),
      '#default_value' => $config->get('api_key'),
      '#key_filters' => ['type' => 'authentication'],
      '#required' => TRUE,
    ];

    $form['host'] = [
      '#type' => 'textfield',
      '#title' => $this->t('API Host'),
      '#default_value' => $config->get('host') ?: 'https://api.moonshot.cn/v1',
      '#description' => $this->t('The base URL for the Moonshot API.'),
      '#required' => TRUE,
    ];

    $form['help'] = [
      '#type' => 'details',
      '#title' => $this->t('Help'),
      '#open' => FALSE,
    ];

    $form['help']['documentation'] = [
      '#type' => 'link',
      '#title' => $this->t('Moonshot API Documentation'),
      '#url' => Url::fromUri('https://platform.moonshot.cn/docs/introduction'),
      '#attributes' => ['target' => '_blank'],
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state)
  {
    $this->config('ai_provider_moonshot.settings')
      ->set('api_key', $form_state->getValue('api_key'))
      ->set('host', $form_state->getValue('host'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
