<?php

namespace Drupal\ai_provider_nanobanana\OperationType;

use Drupal\ai\OperationType\GenericType\ImageFile;
use Drupal\ai\OperationType\ImageToImage\ImageToImageInput;

/**
 * Extended input object for multi-image to image operations.
 *
 * Supports up to 14 images as input for creating composite scenes.
 * - Gemini 2.5 Flash: 1 main + up to 2 additional (3 total)
 * - Gemini 3 Pro: 1 main + up to 13 additional (14 total)
 */
class MultiImageToImageInput extends ImageToImageInput {

  /**
   * Additional image files to use as context.
   *
   * @var \Drupal\ai\OperationType\GenericType\ImageFile[]
   */
  private array $additionalImages = [];

  /**
   * Get additional images.
   *
   * @return \Drupal\ai\OperationType\GenericType\ImageFile[]
   *   The additional images.
   */
  public function getAdditionalImages(): array {
    return $this->additionalImages;
  }

  /**
   * Set additional images.
   *
   * @param \Drupal\ai\OperationType\GenericType\ImageFile[] $images
   *   The additional images (up to 13 for Gemini 3 Pro).
   */
  public function setAdditionalImages(array $images): void {
    $this->additionalImages = $images;
  }

  /**
   * Add an additional image.
   *
   * @param \Drupal\ai\OperationType\GenericType\ImageFile $image
   *   The image to add.
   */
  public function addAdditionalImage(ImageFile $image): void {
    $this->additionalImages[] = $image;
  }

  /**
   * Get all images (main + additional).
   *
   * @return \Drupal\ai\OperationType\GenericType\ImageFile[]
   *   All images.
   */
  public function getAllImages(): array {
    return array_merge([$this->getImageFile()], $this->additionalImages);
  }

}
