# Changelog

All notable changes to the ai_provider_openrouter module will be documented in this file.

## [1.1.1] - 2025-11-12
- Require `drupal/ai` ^1.2.0 for streaming/event/usage features parity.
- Fix chat string-input normalization (messages are now an array of typed content blocks; removes nested model/messages bug).
- Streaming parity with AI module 1.2:
  - Add `stream_options.include_usage = TRUE` to include token usage in streamed chunks.
  - Refactor `OpenRouterStreamedChatMessageIterator` to implement `doIterate()` (not `getIterator()`), enabling base iterator to reconstruct `ChatOutput`, dispatch events, and run callbacks.
  - Map usage and finish reason on streamed chunks similar to OpenAI provider.
- Non-stream responses now set `TokenUsageDto` on `ChatOutput` when usage is returned.
- No database updates required.

## [1.1.0] - 2025-09-13
- Align with latest AI module interfaces.
- Fix `maxEmbeddingsInput(string $model_id = '')` signature to match `EmbeddingsInterface`.
- Remove unsupported `_provider` requirement from `ai_provider_openrouter.routing.yml`.
- Align config schema: rename `selected_models` to `enabled_models`; add `streaming` and `default_provider` keys.
- Refactor DI usage in `OpenRouterConfigForm` and `OpenRouterProvider` (no `\Drupal::service()` calls).
- Implement model filtering in `getConfiguredModels()` based on `enabled_models` and add Kernel test.
- Fix unit test `OpenRouterClientTest` to pass Guzzle client; add docblocks and void return types.
- Hardening in `OpenRouterClient` (null-safe key fetch, typed arrays) and improved error logging.
- PHPCS cleanup across module; add missing docblocks; make PHPStan level 8 largely clean.
- No database updates required.

## [Unreleased]
- Initial scaffolding: service, config form, schema, provider plugin, tests, documentation.
- Added LICENSE.txt and .gitignore.

## [0.1.0] - 2025-05-16
- First commit: OpenRouter provider plugin for Drupal AI module.
- Configuration form for API key and base URL.
- Service class for OpenRouter API communication.
- Basic unit and kernel tests.
- README with install and usage instructions.
