<?php

namespace Drupal\ai_provider_siliconflow\Controller;

use Drupal\ai\Plugin\ProviderProxy;
use Drupal\Component\Serialization\Json;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Routes for autocomplete responses.
 */
class SiliconflowAutocomplete extends ControllerBase {

  /**
   * Handler for autocomplete request.
   */
  public function models(Request $request) {
    $type = $request->query->get('model_type');
    $search = $request->query->get('q');
    $results = [];

    /** @var ProviderProxy $ai_provider */
    $key = \Drupal::service('key.repository')->getKey(\Drupal::config('ai_provider_siliconflow.settings')->get('api_key'));
    $api_key = $key->getKeyValue();
    // Try to get models.
    if (!empty($type) && strlen($search) > 2) {
      $url = "https://api.siliconflow.cn/v1/models?sub_type=$type";
      $request = \Drupal::httpClient()->get($url,[
        'headers' => [
          'Authorization' => 'Bearer ' . $api_key,
        ],
      ]);
      $response = Json::decode($request->getBody()->getContents());
      foreach ($response['data'] as $model) {
        if (str_contains($model['id'], $search)) {
          $results[] = $model['id'];
        }
      }
    }

    // Response.
    return new JsonResponse($results);
  }

}
