# AI LLM Optimized Content recipe
AI-optimized content delivery recipe. Provides llms.txt support, markdown content output, and noise reduction to improve Large Language Model processing efficiency.

## Project Information
- **Drupal.org Project**: https://www.drupal.org/project/ai_recipe_llm_optimized_content
- **Ecosystem**: AI (Artificial Intelligence)

## What it does
The AI LLM Optimized Content Recipe transforms Drupal sites into AI-friendly platforms by automatically generating and optimizing content specifically for large language model (LLM) processing.

## Why it matters
Modern websites need to be optimized not just for human readers and search engines, but also for AI systems that increasingly consume and process web content. This recipe addresses the growing need for content that can be efficiently processed by large language models, reducing computational costs and improving AI understanding of site content. By implementing LLM-optimized content structures, sites can ensure better AI comprehension while maintaining excellent user experience.

## How it works
The recipe leverages the Markdownify module to expose generated Markdown versions of Drupal pages, transforming HTML-rich content into lightweight, AI-ready Markdown format. The Markdownify module converts Drupal's standard HTML rendering into clean Markdown through a seamless process powered by the League HTML-to-Markdown Library, dramatically reducing token usage and enhancing AI optimization.

It also installs the /llms.txt module that creates a default llms.txt file at the root of your website as a "home page" for LLMs and AI agents, and it enables you to further edit and enrich the llms.txt file to optimally guide bots to undestand the intent and structure of your site and expose your key content.

### Key features include:

- Up to 90% reduction in token counts compared to HTML
-Multiple flexible access methods for Markdown content
- Integration with AI providers for content generation and refinement
- Seamless integration with existing Drupal content workflows
- Support for multiple content types and field configurations

## Getting started
### Prerequisites
- Drupal 10.4 or higher
- PHP 8.1 or higher
### Installation
The recipe can be applied using Drupal's recipe system. It will automatically configure the necessary modules and settings to enable LLM-optimized content generation on your site.

## Use cases
- Content optimization: Automatically optimize existing content for better AI processing
- AI-friendly publishing: Generate new content that is structured for optimal LLM consumption
- Cost reduction: Minimize AI processing costs through efficient content structuring
- SEO enhancement: Improve content visibility to AI-powered search systems
- Multilingual support: Optimize content across multiple languages for global AI systems