# AI SEO Optimizer recipe

The AI SEO Optimizer recipe extends the Drupal CMS SEO Tools recipe, adding
AI-powered SEO tools that content creators can use to create and optimize their
content for users and search engines.

## Project Information

- **Drupal.org Project**: https://www.drupal.org/project/ai_recipe_seo_optimizer
- **Ecosystem**: AI (Artificial Intelligence)

### Maintainers
- [breidert](https://www.drupal.org/u/breidert)
- [thejimbirch](https://www.drupal.org/u/thejimbirch)

### Supporting Organizations
- [Kanopi Studios](https://www.drupal.org/kanopi-studios)
- [1xINTERNET](https://www.drupal.org/1xinternet)

## Goals & Guiding Principles

- **Enhance content discoverability** by automating SEO best practices while
  respecting the evolving landscape where content quality and semantic relevance
  are more important than keyword stuffing
- **Save time** for content editors and SEO specialists by reducing repetitive
  manual work (e.g., structured data, meta tag generation, audits)
- **Integrate** with existing Drupal SEO ecosystem (MetaTag, Schema.org,
  JSON-LD, Simple XML Sitemap, Redirect, Pathauto, etc.)
- **Stay future-oriented** by focusing on semantic analysis, user behavior
  signals, and AI-driven assistance, not just old-school SEO tricks

## Features

### AI Focus Keyword Field
Add an "AI Focus Keyword" field to content types to generate:
- H1, Title tags & meta descriptions
- Social card preview images (Open Graph, Twitter)
- Content suggestions (H1, body, subheadings)
- Internal linking anchor text aligned with the keyword

Field Widget Actions will use the keyword token in prompts to generate content:
- Title
- SEO Tools Page Title
- SEO Tools Image
- SEO Tools Description

### AI Optimizer Agent (MVP)
- Analyze draft content for readability, keyword placement, and semantic
  coverage
- Store SEO analysis reports as a field or custom entity type
- Suggest improvements (e.g., missing alt text, weak headings, thin content)

### Phase 2 Features
- Generate structured data (JSON-LD) automatically based on content type and
  schema.org standards
- **Multilingual SEO Support**: Ensure focus keyword, meta tags, and structured
  data support multilingual sites
- Check for correct hreflang links by querying translation status and related
  content entities
- **404 Spotter**: Crawl site with Googlebot UA to detect broken/missing links
- **Link Health Checker**: Verify external links haven't turned malicious or
  low-ranking
- **Meta/URL Audit Agent**: Detect missing path aliases, canonicals, metadata

## Recipe Architecture

This project is part of the broader Drupal AI Initiative SEO Track:

1. **Drupal SEO Tools Recipe** (foundation): Meta, schema, redirects, sitemaps
2. **AI SEO Optimizer Recipe** (this project): Adds focus keyword support,
   structured data generation, and AI-driven content optimization
3. **AI SEO Analyzer Recipe** (future phase): Adds monitoring/auditing tools
   (Lighthouse, SERP API, 404 spotter, link health, etc.)

## Target Audience

- **SEO specialists** ? efficiency tools
- **Content creators** ? AI-assisted optimization  
- **Site builders** ? recipe-based setup with minimal config

## Installation

This recipe extends the Drupal CMS SEO Tools recipe. Ensure you have that
installed first. This recipe also assumes you have at least one content type.

## Development Status

Currently in development. Next steps:
- Prototype the MVP features
- Release Alpha recipe
- Documentation/Demos
- Gather feedback
- Start on Phase 2 features
