This module leverages the AI Search sub-module of the AI module to find related
content. This is sometimes referred to as content recommendations or suggested
content.

## Features

This module provides a Views Block that allows the site builder to configure the
content used to do the automated search in the AI Search (Vector database) and
suggest related content.

The View itself is editable to control things like:

* How many related content items to show
* What View Mode to show related content in
* How should the related content be cached\*

\* *This should not be underestimated, leveraging LLMs to do a vector search has
a cost, caching the related content is important to avoid Denial of Wallet (DOW)
attacks.*

## Post-Installation

1. Configure the AI Search sub-module with a Search API Vector Database.
   [Read the docs on that here](https://project.pages.drupalcode.org/ai/modules/ai_search/).
2. Go to `/admin/config/search/ai-related-content/create` to install the AI
   Related Content View with your Search API Vector Database of choice.
3. Optionally modify your desired View Mode (defaults to Teaser).
4. Optionally modify your caching (defaults to time based).
5. Configure the AI Related Content block to use a non-default View Mode to
   curate the portion of the contents used to search for related content, or use
   Twig Tweak using the snippets shown in the setup form (e.g.,
   `{{ drupal_view('ai_related_content', 'default_block') }}` or
   `{{ drupal_view('ai_related_content', 'default_block', node.id) }}`).

# Contributing

When updating the View 'template', the following steps can be taken:
1. Update the View in Views UI
2. Config export
3. Copy the contents into the template file
4. Remove the UUID
5. Find and replace your own Search API Index ID with 'INDEX_NAME_HERE'
