# AI Report

AI-powered database reporting tool for Drupal that generates SQL queries from natural language questions.

## Description

AI Report allows administrators to query their Drupal database using natural language. Simply ask a question like "Show me all articles created this month" and the AI will generate and execute the appropriate SQL query, displaying results in a formatted table.

## Features

- **Natural Language Queries**: Ask questions in plain English instead of writing SQL
- **AI-Powered**: Uses configurable AI models to understand questions and generate SQL
- **Real-time Results**: AJAX-powered interface with instant results
- **Security First**: Only SELECT queries allowed, destructive operations blocked
- **Database Context Aware**: AI knows your database structure and content types
- **Detailed Debugging**: View generated SQL, AI responses, and prompts
- **Configurable Prompts**: Customize AI behavior through admin settings

## Requirements

- Drupal 9, 10, or 11
- AI module
- Configured AI provider (OpenAI, Anthropic, etc.)

## Installation

1. Download and enable the module:
   ```bash
   drush en ai_report -y
   ```

2. Clear cache:
   ```bash
   drush cr
   ```

## Configuration

1. Navigate to **Configuration → AI → AI Report** (`/admin/config/ai/ai-report`)

2. Configure the following settings:
   - **AI provider/model**: Select which AI model to use (or leave empty for default)
   - **Prompt Configuration**: Customize the system prompt that instructs the AI

3. Save configuration

## Usage

1. Navigate to **Reports → AI Report** (`/admin/reports/ai-report`)

2. Enter your question in natural language, for example:
   - "Show me all users created in the last month"
   - "List all published articles with their authors"
   - "Find all nodes of type 'page' that were updated this week"

3. Click **Make report** (or press Enter)

4. View results in the expandable sections:
   - **Query Results**: The data in a formatted table
   - **AI Response**: Raw response from the AI
   - **Database Structure**: Complete database schema reference
   - **Processed Prompt**: The exact prompt sent to the AI

## Example Queries

### Users
- "Show me the 10 most recent users"
- "List all administrators"
- "Find users who haven't logged in this year"

### Content
- "Show all published articles"
- "List nodes created by user ID 1"
- "Find all content of type 'blog' with 'tutorial' in the title"

### Custom
- "Count how many nodes of each type exist"
- "Show me the most active content authors"
- "List all taxonomy terms used by articles"

## Security

AI Report includes multiple security layers:

1. **Query Type Restriction**: Only SELECT queries are executed
2. **Permission-based Access**: Requires 'access site reports' permission
3. **Configuration Protection**: Settings require 'administer site configuration' permission
4. **No Direct SQL Input**: All queries generated by AI, not user-provided

## Prompt Customization

The default prompt instructs the AI to:
- Only use columns that exist in the database
- Generate MySQL-compliant SQL (SQL:1999 standard)
- Reference actual content types from your site
- Follow Drupal database patterns

Available placeholders:
- `[actual_user_question]`: The user's question
- `[database_structure]`: Complete database schema
- `[contenttypes]`: List of available content types

## Tips for Best Results

1. **Be Specific**: "Show all published articles from 2024" works better than "show articles"
2. **Use Content Type Names**: Reference your actual content types (article, page, etc.)
3. **Mention Fields**: Include field names when filtering ("title contains X")
4. **Check Results**: Always verify the generated SQL and results in debug sections

## Permissions

This module provides two permissions that you can assign at **People → Permissions** (`/admin/people/permissions`):

### Access AI Reports
- **Permission name**: `access ai reports`
- **What it does**: Allows users to view and generate AI-powered database reports
- **Who should have it**: Content managers, analysts, or anyone who needs to query the database
- **Access to**: `/admin/reports/ai-report`

### Administer AI Reports
- **Permission name**: `administer ai reports`
- **What it does**: Allows users to configure AI Report settings including AI model selection and prompt configuration
- **Who should have it**: Site administrators only (this is a restricted permission)
- **Access to**: `/admin/config/ai/ai-report`

**Recommended setup:**
- Give `access ai reports` to trusted roles like "Content Manager" or "Editor"
- Give `administer ai reports` only to "Administrator" role

## Maintainers

- Your Name/Organization

## License

GPL-2.0-or-later
