/**
 * @file
 * AI Report form behaviors.
 */

(function ($, Drupal) {
  'use strict';

  /**
   * Handle Enter key submission for AI Report query textarea.
   *
   * @type {Drupal~behavior}
   */
  Drupal.behaviors.aiReportSubmit = {
    attach: function (context, settings) {
      $('.ai-report-query', context).once('ai-report-submit').on('keydown', function (e) {
        // Check if Enter key is pressed without Shift.
        // Shift+Enter allows for new lines.
        if (e.which === 13 && !e.shiftKey) {
          e.preventDefault();
          // Find the submit button and trigger mousedown to activate AJAX.
          var $submitButton = $(this).closest('form').find('input[type="submit"]').first();
          if ($submitButton.length) {
            // Trigger mousedown event which AJAX buttons listen to.
            $submitButton.trigger('mousedown');
          }
        }
      });
    }
  };

})(jQuery, Drupal);
