# Contributing to AI Revision Log

Thank you for considering contributing to the AI Revision Log module! This document provides guidelines and information for contributors.

## Getting Started

1. **Fork the repository** on drupal.org
2. **Clone your fork** locally
3. **Create a feature branch** from the main development branch
4. **Make your changes** following the guidelines below
5. **Submit a merge request** with a clear description

## Development Setup

### Prerequisites

- PHP 8.1 or higher
- Composer
- Drupal 10+ or 11+ development environment
- Required modules: AI, ECA

### Local Setup

1. Install dependencies:
   ```bash
   composer install
   ```

2. Run coding standards check:
   ```bash
   vendor/bin/phpcs --standard=Drupal,DrupalPractice .
   ```

3. Run tests:
   ```bash
   vendor/bin/phpunit
   ```

## Coding Standards

This project follows Drupal coding standards:

- **PHP**: Follow [Drupal PHP coding standards](https://www.drupal.org/docs/develop/standards/php)
- **Documentation**: All public methods must have proper PHPDoc
- **Testing**: New features require corresponding tests
- **Security**: Follow [Drupal security guidelines](https://www.drupal.org/docs/security-in-drupal)

### Code Quality Tools

We use the following tools to maintain code quality:

- **PHPCS**: PHP Code Sniffer for style checking
- **PHPUnit**: Unit and functional testing
- **PHPStan**: Static analysis (recommended)

## Testing Guidelines

### Unit Tests

- Write unit tests for all new functionality
- Use mocks for external dependencies
- Follow AAA pattern (Arrange, Act, Assert)
- Test both success and failure scenarios

### Integration Tests

- Test ECA integration scenarios
- Verify AI provider interactions
- Test with different entity types

### Test Coverage

- Aim for high test coverage on new code
- Critical functionality must have tests
- Edge cases should be covered

## Submitting Changes

### Merge Request Guidelines

1. **Clear title**: Describe what the change does
2. **Detailed description**: Explain why the change is needed
3. **Link issues**: Reference related issue numbers
4. **Screenshots**: Include for UI changes
5. **Testing**: Describe how the change was tested

### Commit Messages

Follow conventional commit format:

```
type(scope): description

- feat: new features
- fix: bug fixes
- docs: documentation changes
- style: formatting changes
- refactor: code restructuring
- test: adding tests
- chore: maintenance tasks
```

Example:
```
feat(action): add support for custom entity types

- Extend GenerateRevisionLogAction to work with custom entities
- Add configuration for entity type filtering
- Include tests for new functionality
```

## Issue Reporting

When reporting issues:

1. **Search existing issues** first
2. **Use issue templates** when available
3. **Provide clear reproduction steps**
4. **Include system information**:
   - Drupal version
   - Module versions
   - PHP version
   - AI provider details

### Bug Reports

Include:
- Expected behavior
- Actual behavior
- Steps to reproduce
- Error messages/logs
- Environment details

### Feature Requests

Include:
- Use case description
- Proposed solution
- Alternative approaches considered
- Potential impact on existing functionality

## Documentation

### Code Documentation

- All public methods need PHPDoc
- Complex logic requires inline comments
- Use proper @param and @return annotations
- Include @throws for exceptions

### User Documentation

- Update README.md for new features
- Add configuration examples
- Include troubleshooting information
- Update CHANGELOG.md

## Security

### Reporting Security Issues

**Do not open public issues for security vulnerabilities.**

Contact the maintainers directly through:
- Drupal.org private message
- Security team contact form

### Security Guidelines

- Validate all user inputs
- Use Drupal's API for data sanitization
- Never log sensitive information
- Follow OWASP guidelines
- Be mindful of AI provider data handling

## Community Guidelines

### Code of Conduct

- Be respectful and inclusive
- Provide constructive feedback
- Help newcomers learn
- Focus on what's best for the community

### Communication

- Use clear, professional language
- Be patient with questions
- Share knowledge and experience
- Acknowledge contributions

## Getting Help

### Resources

- [Drupal.org documentation](https://www.drupal.org/docs)
- [Module issue queue](https://www.drupal.org/project/issues/ai_revision_log)
- [Drupal Slack](https://drupal.slack.com) #ai channel
- [AI module documentation](https://www.drupal.org/project/ai)

### Mentoring

New contributors are welcome! Reach out if you need:
- Help getting started
- Code review guidance
- Technical mentoring
- Drupal development tips

## Recognition

Contributors will be:
- Listed in CHANGELOG.md
- Credited in release notes
- Added to project maintainers (for significant contributions)
- Recognized in community forums

Thank you for contributing to AI Revision Log!