# AI Revision Log

Automatically generates revision log messages using AI for content changes in Drupal.

## Description

This module provides an ECA action that automatically generates meaningful revision log messages for content changes using AI providers. When content is updated, the module detects changes between revisions and uses AI to create a concise, professional summary of what was modified.

## Features

- Automatic detection of content changes between revisions
- AI-powered generation of revision log messages
- Integration with Drupal's AI module ecosystem
- Support for any AI provider supported by the AI module
- Intelligent filtering of internal Drupal fields
- Configurable through ECA (Event-Condition-Action) system

## Requirements

- Drupal 10.0+ or Drupal 11.0+
- [AI module](https://www.drupal.org/project/ai) (^1.0)
- [ECA module](https://www.drupal.org/project/eca) (^2.0)
- [BPMN.io module](https://www.drupal.org/project/bpmn_io) (^3.0)
- [Key module](https://www.drupal.org/project/key) (^1.20)
- An AI provider module (e.g., AI Provider OpenAI)

### ECA Sub-modules Required

- ECA Base (eca_base)
- ECA Access (eca_access) 
- ECA Content (eca_content)
- ECA UI (eca_ui)
- ECA Workflow (eca_workflow)

## Installation

1. Download and install the AI Revision Log module
2. Install required dependencies:
   - AI module and an AI provider (e.g., AI Provider OpenAI)
   - ECA module with required sub-modules
   - BPMN.io module for visual workflow modeling
   - Key module for secure credential storage
3. Configure an AI provider through the AI module
4. Enable the AI Revision Log module

## Configuration

### AI Provider Setup

1. Install and configure an AI provider module (e.g., ai_provider_openai)
2. Configure your AI provider with appropriate credentials
3. Set up default providers in the AI module configuration

### ECA Integration

1. Navigate to Admin → Configuration → Workflow → ECA
2. Create a new ECA model or edit an existing one
3. Add an event trigger (e.g., "Entity presave")
4. Add the "Generate AI revision log message" action
5. Configure any additional conditions as needed

### Example ECA Configuration

**Event:** Entity presave (for nodes)
**Condition:** Entity has changed (optional)
**Action:** Generate AI revision log message

## Usage

Once configured, the module will automatically:

1. Detect when content entities are updated
2. Compare the current revision with the previous revision
3. Identify meaningful changes (excluding internal Drupal fields)
4. Send change descriptions to the configured AI provider
5. Set the AI-generated summary as the revision log message

## Technical Details

### Supported Entities

The module works with any revisionable entity type, including:
- Nodes (content)
- Custom entities with revision support
- Media entities (if revisionable)

### Field Filtering

The module automatically ignores internal Drupal fields such as:
- `vid` (revision ID)
- `revision_timestamp`
- `revision_uid`
- `revision_log`
- `changed`
- `uuid`
- `langcode`

### AI Integration

The module uses the Drupal AI module's standardized interface:
- Supports any AI provider that implements the Chat operation type
- Uses configurable default providers and models
- Handles AI provider errors gracefully with logging

## API

### Action Plugin

The main functionality is provided by the `GenerateRevisionLogAction` plugin:

```php
\Drupal\ai_revision_log\Plugin\Action\GenerateRevisionLogAction
```

### Services Used

- `ai.provider`: AI Provider Plugin Manager
- `logger.factory`: Logging service

## Troubleshooting

### Common Issues

1. **No revision log messages generated**
   - Verify AI provider is configured and accessible
   - Check that ECA model is enabled and properly configured
   - Ensure the entity type supports revisions

2. **AI provider errors**
   - Check module logs at Admin → Reports → Recent log messages
   - Verify AI provider credentials and configuration
   - Ensure AI provider service is available

3. **Performance concerns**
   - AI requests are made asynchronously where possible
   - Consider rate limiting for high-volume sites
   - Monitor AI provider usage and costs

### Debugging

Enable detailed logging by setting the log level to "Debug" for the `ai_revision_log` channel.

## Contributing

This module follows Drupal coding standards and best practices. Contributions are welcome!

### Development Setup

1. Clone the repository
2. Run `composer install`
3. Set up a local Drupal environment
4. Install required dependencies
5. Run tests with `phpunit`

### Testing

The module includes comprehensive PHPUnit tests. Run them with:

```bash
vendor/bin/phpunit web/modules/custom/ai_revision_log/tests/
```

## Security Considerations

- AI providers may process content data externally
- Review your AI provider's data handling policies
- Consider data sensitivity when enabling this module
- Monitor AI provider access logs

## License

This project is licensed under the GPL-2.0+ license - see the [LICENSE](LICENSE) file for details.

## Support

For issues and support:
1. Check the [issue queue](https://www.drupal.org/project/issues/ai_revision_log)
2. Review the documentation
3. Post detailed bug reports with steps to reproduce

## Related Modules

- [AI](https://www.drupal.org/project/ai) - Core AI functionality
- [ECA](https://www.drupal.org/project/eca) - Event-Condition-Action system
- [BPMN.io](https://www.drupal.org/project/bpmn_io) - Visual workflow modeling
- [Key](https://www.drupal.org/project/key) - Secure credential storage
- [AI Provider OpenAI](https://www.drupal.org/project/ai_provider_openai) - OpenAI integration

## Changelog

### 1.0.0
- Initial release
- Basic AI revision log generation
- ECA integration
- Support for revisionable entities