<?php

namespace Drupal\Tests\ai_search\Functional\Controller;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests the provider setup list controller.
 *
 * @group ai_search
 */
class AiSearchVdbProviderSetupListTest extends BrowserTestBase {

  /**
   * The modules to enable for this test.
   *
   * @var array
   */
  protected static $modules = [
    'system',
    'user',
    'ai',
  ];

  /**
   * Theme to enable.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    // Create container.
    $this->container->get('kernel')->rebuildContainer();
    \Drupal::setContainer($this->container);
  }

  /**
   * Tests that the vdb page show a message when allowed with provider.
   */
  public function testProviderVdbListingPageProviderAccess(): void {
    $this->container->get('module_installer')->install(
      [
        'ai_search',
        'search_api',
        'test_ai_vdb_provider_mysql',
      ]
    );

    $account = $this->drupalCreateUser([
      'administer ai providers',
      'administer ai',
      'administer site configuration',
      'access content',
      'view the administration theme',
      'access administration pages',
    ]);

    $this->drupalLogin($account);

    $this->drupalGet('admin/config/ai/vdb_providers');
    $this->assertSession()->statusCodeEquals(200);

    // Test that there is not an empty reaction rule listing.
    $this->assertSession()->pageTextNotContains('No vector database provider is configured.');
    $this->assertSession()->pageTextContains('Test MySQL VDB Provider');
  }

}
