<?php

/**
 * @file
 * The Api documentation for this module.
 */

use Drupal\Component\Render\MarkupInterface;
use Drupal\Core\Entity\EntityInterface;

/**
 * Implements hook_ai_search_block_prompt_alter().
 */
function hook_ai_search_block_prompt_alter(string &$prompt): void {
  $variable = time();
  // Alter the prompt here.
  $prompt = str_replace('[my custom token]', (string) $variable, $prompt);
}

/**
 * Implements hook_ai_search_block_entity_html_alter().
 */
function hook_ai_search_block_entity_html_alter(MarkupInterface|string &$rendered_entity, EntityInterface $entity): void {
  // Change the html for the entity.
}

/**
 * Implements hook_ai_search_block_entity_markdown_alter().
 */
function hook_ai_search_block_entity_markdown_alter(string &$rendered_entity, EntityInterface|null $entity): void {
  // Change the markdown for the entity.
}
