/* global Chart */
(function (Drupal, drupalSettings) {
  'use strict';

  Drupal.behaviors.aiSearchBlockLogGraphs = {
    attach: function (context, settings) {
      const submissionsCanvas = context.querySelector('#aiSearchBlockSubmissionsChart');
      const avgScoreCanvas = context.querySelector('#aiSearchBlockAvgScoreChart');
      const scoresCanvas = context.querySelector('#aiSearchBlockScoresChart');
      const blockCanvas = context.querySelector('#aiSearchBlockByBlockChart');
      const userPieCanvas = context.querySelector('#aiSearchBlockUserPieChart');
      const blockPieCanvas = context.querySelector('#aiSearchBlockBlockPieChart');

      // Check if drupalSettings exists
      if (!drupalSettings.ai_search_block_log) {
        return;
      }

      const chartData = drupalSettings.ai_search_block_log.chart_data || {};
      const uniqueScores = drupalSettings.ai_search_block_log.unique_scores || [];
      const uniqueBlocks = drupalSettings.ai_search_block_log.unique_blocks || [];
      const userData = drupalSettings.ai_search_block_log.user_data || {};
      const blockTotals = drupalSettings.ai_search_block_log.block_totals || {};

      // Graph 1: Total Submissions with individual block lines
      if (submissionsCanvas && !submissionsCanvas.chart && chartData.submissions) {
        const submissionColors = [
          'rgb(255, 99, 132)',
          'rgb(54, 162, 235)',
          'rgb(255, 206, 86)',
          'rgb(153, 102, 255)',
          'rgb(255, 159, 64)',
          'rgb(201, 203, 207)',
          'rgb(83, 102, 255)',
          'rgb(255, 83, 102)',
          'rgb(102, 255, 178)',
        ];

        const submissionDatasets = [
          {
            label: 'Total Searches',
            data: chartData.submissions,
            borderColor: 'rgb(75, 192, 192)',
            backgroundColor: 'rgba(75, 192, 192, 0.2)',
            tension: 0.1,
            borderWidth: 3,
            fill: false,
          },
        ];

        // Add individual block lines
        uniqueBlocks.forEach((blockId, index) => {
          const color = submissionColors[index % submissionColors.length];
          submissionDatasets.push({
            label: `Block: ${blockId}`,
            data: chartData.block_lines[blockId],
            borderColor: color,
            backgroundColor: color.replace('rgb', 'rgba').replace(')', ', 0.1)'),
            tension: 0.1,
            borderWidth: 2,
            fill: false,
          });
        });

        const ctx1 = submissionsCanvas.getContext('2d');
        submissionsCanvas.chart = new Chart(ctx1, {
        type: 'line',
        data: {
          labels: chartData.labels,
          datasets: submissionDatasets,
        },
        options: {
          responsive: true,
          interaction: {
            mode: 'index',
            intersect: false,
          },
          plugins: {
            legend: {
              display: true,
              position: 'bottom',
            },
          },
          scales: {
            y: {
              type: 'linear',
              display: true,
              title: {
                display: true,
                text: 'Number of Searches',
              },
              beginAtZero: true,
            },
          },
        },
      });
      }

      // Graph 2: Average Score with individual block lines
      if (avgScoreCanvas && !avgScoreCanvas.chart && chartData.avg_scores) {
      const avgScoreColors = [
        'rgb(54, 162, 235)',
        'rgb(255, 206, 86)',
        'rgb(153, 102, 255)',
        'rgb(255, 159, 64)',
        'rgb(201, 203, 207)',
        'rgb(83, 102, 255)',
        'rgb(255, 83, 102)',
        'rgb(102, 255, 178)',
      ];

      const avgScoreDatasets = [
        {
          label: 'Average Score',
          data: chartData.avg_scores,
          borderColor: 'rgb(255, 99, 132)',
          backgroundColor: 'rgba(255, 99, 132, 0.2)',
          tension: 0.1,
          borderWidth: 3,
          fill: true,
        },
      ];

      // Add individual block average score lines
      uniqueBlocks.forEach((blockId, index) => {
        const color = avgScoreColors[index % avgScoreColors.length];
        avgScoreDatasets.push({
          label: `Block: ${blockId}`,
          data: chartData.block_avg_scores[blockId],
          borderColor: color,
          backgroundColor: color.replace('rgb', 'rgba').replace(')', ', 0.1)'),
          tension: 0.1,
          borderWidth: 2,
          fill: false,
        });
      });

      const ctx2 = avgScoreCanvas.getContext('2d');
      avgScoreCanvas.chart = new Chart(ctx2, {
        type: 'line',
        data: {
          labels: chartData.labels,
          datasets: avgScoreDatasets,
        },
        options: {
          responsive: true,
          interaction: {
            mode: 'index',
            intersect: false,
          },
          plugins: {
            legend: {
              display: true,
              position: 'bottom',
            },
          },
          scales: {
            y: {
              type: 'linear',
              display: true,
              title: {
                display: true,
                text: 'Average Score',
              },
              beginAtZero: true,
            },
          },
        },
      });
      }

      // Graph 3: Score Distribution
      if (scoresCanvas && !scoresCanvas.chart && chartData.score_lines && uniqueScores.length > 0) {
      const colors = [
        'rgb(54, 162, 235)',
        'rgb(255, 206, 86)',
        'rgb(153, 102, 255)',
        'rgb(255, 159, 64)',
        'rgb(201, 203, 207)',
        'rgb(83, 102, 255)',
        'rgb(255, 83, 102)',
      ];

      const scoreDatasets = [];
      uniqueScores.forEach((score, index) => {
        const color = colors[index % colors.length];
        scoreDatasets.push({
          label: `Score ${score}`,
          data: chartData.score_lines[score],
          borderColor: color,
          backgroundColor: color.replace('rgb', 'rgba').replace(')', ', 0.2)'),
          tension: 0.1,
        });
      });

      const ctx3 = scoresCanvas.getContext('2d');
      scoresCanvas.chart = new Chart(ctx3, {
        type: 'line',
        data: {
          labels: chartData.labels,
          datasets: scoreDatasets,
        },
        options: {
          responsive: true,
          interaction: {
            mode: 'index',
            intersect: false,
          },
          plugins: {
            legend: {
              display: true,
              position: 'bottom',
            },
          },
          scales: {
            y: {
              type: 'linear',
              display: true,
              title: {
                display: true,
                text: 'Count',
              },
              beginAtZero: true,
            },
          },
        },
      });
      }

      // Graph 4: Submissions by Block (Stacked)
      if (blockCanvas && !blockCanvas.chart && chartData.block_lines && uniqueBlocks.length > 0) {
      const blockColors = [
        'rgb(255, 99, 132)',
        'rgb(54, 162, 235)',
        'rgb(255, 206, 86)',
        'rgb(75, 192, 192)',
        'rgb(153, 102, 255)',
        'rgb(255, 159, 64)',
        'rgb(201, 203, 207)',
        'rgb(83, 102, 255)',
        'rgb(255, 83, 102)',
        'rgb(102, 255, 178)',
      ];

      const blockDatasets = [];
      uniqueBlocks.forEach((blockId, index) => {
        const color = blockColors[index % blockColors.length];
        blockDatasets.push({
          label: blockId,
          data: chartData.block_lines[blockId],
          borderColor: color,
          backgroundColor: color.replace('rgb', 'rgba').replace(')', ', 0.5)'),
          tension: 0.1,
          fill: true,
        });
      });

      const ctx4 = blockCanvas.getContext('2d');
      blockCanvas.chart = new Chart(ctx4, {
        type: 'line',
        data: {
          labels: chartData.labels,
          datasets: blockDatasets,
        },
        options: {
          responsive: true,
          interaction: {
            mode: 'index',
            intersect: false,
          },
          plugins: {
            legend: {
              display: true,
              position: 'bottom',
            },
          },
          scales: {
            y: {
              type: 'linear',
              display: true,
              stacked: true,
              title: {
                display: true,
                text: 'Searches',
              },
              beginAtZero: true,
            },
          },
        },
      });
      }

      // Pie Chart Colors - User Chart
      const userPieColors = [
        'rgb(255, 99, 132)',   // Red
        'rgb(54, 162, 235)',   // Blue
        'rgb(255, 206, 86)',   // Yellow
        'rgb(75, 192, 192)',   // Teal
        'rgb(153, 102, 255)',  // Purple
        'rgb(255, 159, 64)',   // Orange
        'rgb(231, 233, 237)',  // Gray
        'rgb(255, 99, 255)',   // Pink
        'rgb(99, 255, 132)',   // Light Green
        'rgb(132, 99, 255)',   // Violet
        'rgb(255, 193, 7)',    // Amber
        'rgb(0, 188, 212)',    // Cyan
        'rgb(76, 175, 80)',    // Green
        'rgb(233, 30, 99)',    // Deep Pink
        'rgb(156, 39, 176)',   // Deep Purple
      ];

      // Pie Chart Colors - Block Chart
      const blockPieColors = [
        'rgb(103, 58, 183)',   // Deep Purple
        'rgb(33, 150, 243)',   // Light Blue
        'rgb(0, 150, 136)',    // Teal
        'rgb(139, 195, 74)',   // Light Green
        'rgb(255, 235, 59)',   // Yellow
        'rgb(255, 152, 0)',    // Orange
        'rgb(244, 67, 54)',    // Red
        'rgb(121, 85, 72)',    // Brown
        'rgb(158, 158, 158)',  // Gray
        'rgb(96, 125, 139)',   // Blue Gray
        'rgb(233, 30, 99)',    // Pink
        'rgb(156, 39, 176)',   // Purple
        'rgb(63, 81, 181)',    // Indigo
        'rgb(0, 188, 212)',    // Cyan
        'rgb(205, 220, 57)',   // Lime
      ];

      // Pie Chart 1: Submissions by User
      if (userPieCanvas && !userPieCanvas.chart && userData && Object.keys(userData).length > 0) {
        const userLabels = Object.keys(userData);
        const userCounts = Object.values(userData);
        // Randomly assign colors to users
        const userColors = userLabels.map(() => {
          const randomIndex = Math.floor(Math.random() * userPieColors.length);
          return userPieColors[randomIndex];
        });

        const ctx5 = userPieCanvas.getContext('2d');
        userPieCanvas.chart = new Chart(ctx5, {
          type: 'pie',
          data: {
            labels: userLabels,
            datasets: [
              {
                label: 'Searches',
                data: userCounts,
                backgroundColor: userColors,
                borderWidth: 1,
                borderColor: '#fff',
              },
            ],
          },
          options: {
            responsive: true,
            plugins: {
              legend: {
                display: true,
                position: 'bottom',
              },
              tooltip: {
                callbacks: {
                  label: function (context) {
                    const label = context.label || '';
                    const value = context.parsed || 0;
                    const total = context.dataset.data.reduce((a, b) => a + b, 0);
                    const percentage = total > 0 ? ((value / total) * 100).toFixed(2) : 0;
                    return `${label}: ${value} (${percentage}%)`;
                  },
                },
              },
            },
          },
        });
      }

      // Pie Chart 2: Submissions Distribution by Block (%)
      if (blockPieCanvas && !blockPieCanvas.chart && blockTotals && Object.keys(blockTotals).length > 0) {
        const blockLabels = Object.keys(blockTotals);
        const blockCounts = Object.values(blockTotals);
        const blockColors = blockLabels.map((label, index) => blockPieColors[(index % blockPieColors.length) + 1]);

        const ctx6 = blockPieCanvas.getContext('2d');
        blockPieCanvas.chart = new Chart(ctx6, {
          type: 'pie',
          data: {
            labels: blockLabels,
            datasets: [
              {
                label: 'Searches',
                data: blockCounts,
                backgroundColor: blockColors,
                borderWidth: 1,
                borderColor: '#fff',
              },
            ],
          },
          options: {
            responsive: true,
            plugins: {
              legend: {
                display: true,
                position: 'bottom',
              },
              tooltip: {
                callbacks: {
                  label: function (context) {
                    const label = context.label || '';
                    const value = context.parsed || 0;
                    const total = context.dataset.data.reduce((a, b) => a + b, 0);
                    const percentage = total > 0 ? ((value / total) * 100).toFixed(2) : 0;
                    return `${label}: ${value} (${percentage}%)`;
                  },
                },
              },
            },
          },
        });
      }
    },
  };
})(Drupal, drupalSettings);
