<?php

namespace Drupal\ai_search_block_log\Controller;

use Drupal\Core\Controller\ControllerBase;
// Adjust namespace if necessary.
use Drupal\ai_search_block_log\AiSearchBlockLogHelper;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

/**
 * An example controller.
 */
class AiSearchBlockLogController extends ControllerBase {

  /**
   * Constructs a new AiSearchBlockLogController.
   *
   * @param \Drupal\ai_search_block_log\AiSearchBlockLogHelper $helper
   *   The log helper service.
   */
  public function __construct(
    protected AiSearchBlockLogHelper $helper,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): AiSearchBlockLogController {
    return new static(
      $container->get('ai_search_block_log.helper')
    );
  }

  /**
   * Returns a renderable array for a test page.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The current request.
   *
   * @return \Symfony\Component\HttpFoundation\JsonResponse
   *   A JSON response.
   */
  public function score(Request $request): JsonResponse {
    $logId = $request->get('log_id');
    if (empty($logId)) {
      throw new NotFoundHttpException('Log ID not found.');
    }

    $score = $request->get('score');
    $this->helper->update((int) $logId, ['score' => (int) $score]);
    if ($feedback = $request->get('feedback')) {
      $this->helper->update((int) $logId, ['feedback' => $feedback]);
    }

    return new JsonResponse([
      'response' => $this->t('Thank you for your feedback.'),
    ]);
  }

}
