<?php

namespace Drupal\ai_search_block\Plugin\Block;

use Drupal\Core\Block\BlockBase;

/**
 * Provides an AI form block.
 *
 * @Block(
 *   id = "ai_search_block_response",
 *   admin_label = @Translation("AI Search response"),
 *   category = @Translation("AI")
 * )
 */
class SearchResponseBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function build(): array {
    $block = [];
    $block['#settings'] = $this->configuration;
    $block['#theme'] = 'ai_search_block_response';
    $block['#output'] = ' ';

    return $block;
  }

}
