<?php

namespace Drupal\ai_seo\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface for defining Report Type entities.
 */
interface ReportTypeInterface extends ConfigEntityInterface {

  /**
   * Gets the Report Type description.
   *
   * @return string
   *   Description of the Report Type.
   */
  public function getDescription();

  /**
   * Sets the Report Type description.
   *
   * @param string $description
   *   The Report Type description.
   *
   * @return \Drupal\ai_seo\Entity\ReportTypeInterface
   *   The called Report Type entity.
   */
  public function setDescription($description);

  /**
   * Gets the prompt text.
   *
   * @return string
   *   The prompt text for this report type.
   */
  public function getPrompt();

  /**
   * Sets the prompt text.
   *
   * @param string $prompt
   *   The prompt text.
   *
   * @return \Drupal\ai_seo\Entity\ReportTypeInterface
   *   The called Report Type entity.
   */
  public function setPrompt($prompt);

}
