<?php

namespace Drupal\ai_seo_link_advisor\Analyzer\HttpClient;

use Psr\Http\Message\ResponseInterface;

/**
 * Defines an interface for HTTP clients used by the SEO Link Advisor module.
 */
interface ClientInterface {

  /**
   * Sends a GET request to the specified URL.
   *
   * @param string $url
   *   The URL to send the GET request to.
   * @param array $options
   *   An array of options to customize the request.
   *
   * @return \Psr\Http\Message\ResponseInterface
   *   The response returned from the request.
   *
   * @throws \Drupal\ai_seo_link_advisor\Analyzer\HttpClient\Exception\HttpException
   *   If the request fails or an error occurs.
   */
  public function get(string $url, array $options = []): ResponseInterface;

}
