<?php

namespace Drupal\ai_seo_link_advisor\Analyzer\Metric\Page;

use Drupal\ai_seo_link_advisor\Analyzer\Metric\AbstractMetric;

/**
 * Provides a KeywordTitleMetric class for SEO analysis.
 */
class KeywordTitleMetric extends AbstractMetric {

  /**
   * Analyzes page.
   */
  public function analyze(): string {
    $this->description = $this->t('Does the meta title contain the keyword?');
    $this->name = 'Keyword' . ($this->value['type'] ?? 'Unknown');

    // Check if $this->value is an array and has the 'text' key.
    if (is_array($this->value) && isset($this->value['text'])) {
      if (empty($this->value['text'])) {
        $this->impact = 10;
        return $this->t('You do not have a meta <title> tag. You should add this because it is really important for your SEO');
      }

      // Check if the title contains the keyword.
      if (isset($this->value['keyword']) && is_string($this->value['keyword'])) {
        if (stripos($this->value['text'], $this->value['keyword']) === FALSE) {
          $this->impact = $this->value['impact'] ?? 'Unknown Impact';
          return $this->t('Cannot find the keyword in the meta title tag. Adding it could improve SEO');
        }
        return $this->t('Good! Found the keyword in the meta title tag');
      }
      // Handle cases where keyword is not valid.
      return $this->t('Invalid keyword data provided for analysis.');
    }

    // Handle cases where $this->value is not array or missing 'text' key.
    return $this->t('Invalid input data for meta title analysis.');
  }

}
