# AI SEO Link Advisor

The AI SEO Link Advisor module integrates Drupal with the
[AI](https://www.drupal.org/project/ai) contributed module to provide SEO
analysis and intelligent recommendations using AI providers supported by the AI
ecosystem.

It allows you to configure AI services and analyze URLs directly from your
Drupal site to receive content-level insights and SEO-focused metrics.

## Features

- Uses [AI module](https://www.drupal.org/project/ai) and its supported
providers.
- Analyze any Internal URL for SEO purposes using the
**`/ai-seo-link-advisor-form`** page.
- Provides content-level metrics, general SEO insights, and AI-generated
recommendations.
- Validates user-entered URLs to ensure correctness.

## Requirements

- Contributed module - [AI](https://www.drupal.org/project/ai)
- At least one AI provider plugin installed and configured.

## Installation

### Using the Drupal UI (simple method)

1. Go to **Extend** (`/admin/modules`) in the admin toolbar.
2. Search for AI SEO Link Advisor and enable the checkbox.
3. Click **Install** to enable the module.

### Using Drush (advanced)

- To enable AI SEO Link Advisor module with Drush, execute the command
  below: <br> `drush en ai_seo_link_advisor`

## Configuration

1. Enable the AI module.
2. Choose and enable an AI Provider module.
3. Download the AI Provider and install and configure, according to its
instructions.
4. Configure the AI provider for the Chat operation type.

## Maintainers

- [Vishal Kadam](https://www.drupal.org/u/vishalkadam)
