<?php

namespace Drupal\ai_seo_link_advisor\Analyzer\Metric;

/**
 * Provides a MetricFactory class for SEO analysis.
 */
class MetricFactory {

  /**
   * Analyzes page at specified get.
   */
  public static function get(string $key, $inputData = NULL) {
    $class = __NAMESPACE__;
    $path = explode(".", $key);

    foreach ($path as $level) {
      $class .= '\\' . ucfirst($level);
    }

    $class .= 'Metric';

    if (class_exists($class)) {
      $metric = new $class($inputData);

      if (empty($metric->name)) {
        throw new \InvalidArgumentException('Missing metric name for class: ' . $class);
      }

      return $metric;
    }
  }

}
