<?php

namespace Drupal\ai_seo_link_advisor\Analyzer\Parser;

/**
 * Provides an ExampleCustomParser parser class for SEO analysis.
 */
class ExampleCustomParser extends Parser {

  /**
   * Retrieves the alt and src attributes of all <img> elements in the DOM.
   *
   * Scans all image tags and returns an array of associative arrays,
   * each containing the trimmed `alt` and `src` attributes.
   *
   * @return array
   *   A list of images, where each item contains:
   *   - alt: string The alt text of the image (maybe empty).
   *   - src: string The image source URL.
   */
  public function getImages(): array {
    $alts = [];

    if ($this->getDomElements('img')->length > 0) {
      foreach ($this->getDomElements('img') as $img) {
        $alts[] = [
          'alt' => trim($img->getAttribute('alt')),
          'src' => trim($img->getAttribute('src')),
        ];
      }
    }

    return $alts;
  }

}
