<?php

declare(strict_types=1);

namespace Drupal\ai_seo_link_advisor\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Hook implementations for ai_seo_link_advisor.
 */
class AiSeoLinkAdvisorHooks {

  use StringTranslationTrait;

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help($route_name, RouteMatchInterface $route_match): ?string {
    if ($route_name == 'help.page.ai_seo_link_advisor') {
      return '<p>' . $this->t('Check SEO metrics for a given url and provides AI-based recommendations.') . '</p>';
    }
    return NULL;
  }

}
