# AI SEO Link Advisor

The AI SEO Link Advisor module integrates Drupal with a range of AI services,
such as OpenAI and Gemini, to offer SEO analysis and recommendations. It enables
you to set up AI services and conduct SEO evaluations on URLs directly from your
Drupal site.

## Features

- Choose from different AI services.
- Configure AI service settings, including selecting different AI models.
- Analyze a URL's SEO using the **`'/seo-linkchecker'`** page, where users input
a website URL to receive content-level and general metrics, along with AI
recommendations.
- The module can verify if the entered URL is correct or incorrect.
- You can modify the AI service and model settings anytime through the
configuration page.

## Requirements

- Contributed module - [AI](https://www.drupal.org/project/ai)
- It requires at least one AI Provider to be installed and configured.

## Installation

### Using the Drupal User Interface (easy):

1. Navigate to the 'Extend' page (admin/modules) via the manage administrative
   menu.
2. Locate the AI SEO Link Advisor module and select the checkbox next to
   it.
3. Click on 'Install' to enable the AI SEO Link Advisor module.

### Or use the command line (advanced, but very efficient).

- To enable AI SEO Link Advisor module with Drush, execute the command
  below: <br> `drush en ai_seo_link_advisor`

## Configuration

1. Navigate to the AI advisor configuration page:
    ```
    Administration > Configuration > System > AI SEO Link Advisor
    ```
2. Choose your preferred AI service (OpenAI or Gemini).

3. Input the API key for the selected AI service. Ensure that you generate and
store API keys using the `key` module.

4. Select the AI model to use for the chosen service.

## Maintainers

- [Vishal Kadam](https://www.drupal.org/u/vishalkadam)
