<?php

namespace Drupal\ai_seo_link_advisor\Analyzer\Metric;

use Drupal\Component\Annotation\Plugin;

/**
 * Provides an AbstractMetric class for SEO analysis.
 */
abstract class AbstractMetric extends Plugin implements MetricInterface {

  use \Drupal\Core\StringTranslation\StringTranslationTrait;

  /**
   * Headers constant.
   */
  const HEADERS = 'headers';

  /**
   * Description constant.
   */
  const DESCRIPTION = 'description';

  /**
   * The name of the metric.
   *
   * @var string
   */
  public $name;

  /**
   * The description of the metric.
   *
   * @var string
   */
  public $description;

  /**
   * The value of the metric.
   *
   * @var string
   */
  public $value;

  /**
   * The impact of the metric.
   *
   * @var int
   */
  public $impact = 0;

  /**
   * Constructs a new AbstractMetric instance.
   *
   * @param mixed $inputData
   *   The input data for the metric.
   */
  public function __construct($inputData) {
    if (empty($this->name)) {
      $this->name = str_replace([
        'Drupal\\',
        'ai_seo_link_advisor\\',
        'Analyzer\\',
        'Metric',
        '\\',
      ], '', (new \ReflectionClass($this))->getName());
    }

    $this->value = $inputData;
  }

}
